//
//  GSVodListParamController.m
//  PlayerSDKDemo
//
//  Created by 张俞 on 2023/8/15.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import "GSVodListParamController.h"
#import "GSVodListTableViewController.h"
#import "GSVodTestViewController.h"

#import "GSTextFieldTitleView.h"
#import <GSCommonKit/GSCommonKit.h>
#import "IQKeyboardManager.h"
#import "GSVodTools.h"
#define FASTSDK_COLOR16(value) [UIColor colorWithRed:((float)((value & 0xFF0000) >> 16))/255.0 green:((float)((value & 0xFF00) >> 8))/255.0 blue:((float)(value & 0xFF))/255.0 alpha:1.0]

#define MO_DOMAIN @"V_FAST_Multi_CONFIG_DOMAIN"
#define MO_SERVICE @"V_FAST_Multi_CONFIG_SERVICE_TYPE"
#define MO_ROOMID @"V_FAST_Multi_CONFIG_ROOMID"
#define MO_NICKNAME @"V_FAST_Multi_CONFIG_NICKNAME"
#define MO_PWD @"V_FAST_Multi_CONFIG_PWD"
#define MO_LOGIN_NAME @"V_FAST_Multi_CONFIG_LOGIN_NAME"
#define MO_LOGIN_PWD @"V_FAST_Multi_CONFIG_LOGIN_PWD"
#define MO_THIRD_KEY @"V_FAST_Multi_CONFIG_THIRD_KEY"
#define MO_REWARD @"V_FAST_Multi_CONFIG_REWARD"
#define MO_USERID @"V_FAST_Multi_CONFIG_USERID"


@interface GSVodListParamController () <UITextFieldDelegate,VodDownLoadDelegate>
//UI
@property (nonatomic, strong) UIScrollView  *scrollView;
@property (nonatomic, strong) NSMutableDictionary  *fieldViewsDic;
//config
@property (strong, nonatomic) UISegmentedControl *serviceType;
@property (strong, nonatomic) UISegmentedControl *flvType;
@property (strong, nonatomic) UISegmentedControl *hardType;
@property (strong, nonatomic) UISegmentedControl *httpType;

@property (strong, nonatomic) UISegmentedControl *aspectType;
@property (strong, nonatomic) UISegmentedControl *chatType;
@property (strong, nonatomic) UISegmentedControl *renderType;
@property (nonatomic, strong) UILabel * memoryLabel;
@property (strong, nonatomic) UISegmentedControl *pixelFormatType;

@end

@implementation GSVodListParamController
{
    struct {
        unsigned int isOnline : 1;
    } _state;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [[IQKeyboardManager sharedManager] setEnable:YES];
    self.automaticallyAdjustsScrollViewInsets = NO;
    self.memoryLabel.text = [NSString stringWithFormat:@"在线观看文件内存: %@",[GSVodTools getOnLineVodFilesSizeWithPath:[GSVodObject getVodOnlineFilesPath]]];

}

- (void)viewDidLoad {
    [super viewDidLoad];
    //UI
    self.title = @"VodSDK";
    self.view.backgroundColor = [UIColor groupTableViewBackgroundColor];
    _fieldViewsDic = [[NSMutableDictionary alloc]init];
    self.scrollView                     = [[UIScrollView alloc] initWithFrame:CGRectMake(0, 64, Width, Height - 64 - 50)];
    self.scrollView.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
    self.scrollView.alwaysBounceVertical = YES;
    [self.view addSubview:self.scrollView];
    CGFloat top = 10.f;
    int index = 0;
    
    UILabel *label = [self createTagLabel:@"点播参数设置" top:top];
    [self.scrollView addSubview:label];
    top = label.bottom + 5;
    
    UIView *whiteBGView  = [self createWhiteBGViewWithTop:top itemCount:8];
    top = whiteBGView.bottom + 10;
    [self.scrollView addSubview:whiteBGView];
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"域名";
        fieldView.placeHolder               = @"请输入域名";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_DOMAIN];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"房间号";
        fieldView.placeHolder               = @"请输入房间号(多个房间号用逗号分隔)";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        fieldView.field.keyboardType = UIKeyboardTypeNumberPad;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_ROOMID];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"昵称";
        fieldView.placeHolder               = @"请输入昵称";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_NICKNAME];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"房间密码";
        fieldView.placeHolder               = @"请输入房间密码(可选，多个房间密码用逗号分隔)";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        //        fieldView.field.keyboardType = UIKeyboardTypeNumberPad;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_PWD];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"登录用户名";
        fieldView.placeHolder               = @"请输入登录用户名(可选)";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_LOGIN_NAME];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"登录密码";
        fieldView.placeHolder               = @"请输入登录密码(可选)";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_LOGIN_PWD];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"第三方验证码";
        fieldView.placeHolder               = @"请输入验证码(可选)";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_THIRD_KEY];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"自定义用户ID";
        fieldView.placeHolder               = @"请输入ID(可选,且应大于十亿)";
        //        fieldView.field.delegate            = self;
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        fieldView.field.keyboardType = UIKeyboardTypeNumberPad;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_USERID];
        index ++;
    }
    
    //segement
    {
        UILabel *label = [self createTagLabel:@"站点类型" top:top];
        [self.scrollView addSubview:label];
        
        UILabel *label1 = [self createTagLabel:@"FLV" top:top left:Width/2 + 15];
        [self.scrollView addSubview:label1];
        top = label.bottom + 5;
        //Webcast/Trainig
        _serviceType = [[UISegmentedControl alloc] initWithItems:@[@"Webcast",@"Training"]];
        _serviceType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
        _serviceType.tag = 0;
        //        _serviceType
        _serviceType.selectedSegmentIndex = 0;
        //        [_serviceType addTarget:self action:@selector(segementChanged:) forControlEvents:UIControlEventValueChanged];
        [self.scrollView addSubview:_serviceType];
        //Theme
        _flvType = [[UISegmentedControl alloc] initWithItems:@[@"否",@"是"]];
        _flvType.frame = CGRectMake(Width/2 + 15, top, (Width - 60)/2, 28);
        _flvType.selectedSegmentIndex = 0;
        _flvType.tag = 1;
        //        [_flvType addTarget:self action:@selector(segementChanged:) forControlEvents:UIControlEventValueChanged];
        [self.scrollView addSubview:_flvType];
        
        top = _flvType.bottom + 10;
        
        UILabel *label2 = [self createTagLabel:@"HTTP/HTTPS" top:top];
        [self.scrollView addSubview:label2];
        UILabel *label3 = [self createTagLabel:@"软解/硬解" top:top left:Width/2 + 15];
        [self.scrollView addSubview:label3];
        
        top = label2.bottom + 5;
        //HTTP/HTTPS
        _httpType = [[UISegmentedControl alloc] initWithItems:@[@"HTTP",@"HTTPS"]];
        _httpType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
        _httpType.tag = 2;
        _httpType.selectedSegmentIndex = 0;
        //        [_httpType addTarget:self action:@selector(segementChanged:) forControlEvents:UIControlEventValueChanged];
        [self.scrollView addSubview:_httpType];
        
        
        
        
        
        _hardType = [[UISegmentedControl alloc] initWithItems:@[@"软解",@"硬解"]];
        _hardType.frame = CGRectMake(Width/2 + 15, top, (Width - 60)/2, 28);
        _hardType.selectedSegmentIndex = 0;
        _hardType.tag = 3;
        [self.scrollView addSubview:_hardType];
        
        top = _httpType.bottom + 10;
    }

    
    //segement
    {
        UILabel *label = [self createTagLabel:@"渲染类型" top:top];
        [self.scrollView addSubview:label];
        
        UILabel *label1 = [self createTagLabel:@"软解像素格式" top:top left:Width/2 +15];
        [self.scrollView addSubview:label1];
        
        //        UILabel *label1 = [self createTagLabel:@"屏幕适配类型" top:top left:Width/2 + 15];
        //        [self.scrollView addSubview:label1];
        top = label.bottom + 5;
        //Webcast/Trainig
        _renderType = [[UISegmentedControl alloc] initWithItems:@[@"OpenGL",@"AVSBDLayer"]];
        _renderType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
        _renderType.tag = 0;
        //        _serviceType
        _renderType.selectedSegmentIndex = 0;
        //        [_serviceType addTarget:self action:@selector(segementChanged:) forControlEvents:UIControlEventValueChanged];
        [self.scrollView addSubview:_renderType];
        
        
        _pixelFormatType = [[UISegmentedControl alloc] initWithItems:@[@"RGBA",@"RGB"]];
        _pixelFormatType.frame = CGRectMake(Width/2+15, top, (Width - 60)/2, 28);
        _pixelFormatType.tag = 2;
        //        _serviceType
        _pixelFormatType.selectedSegmentIndex = 0;
        [self.scrollView addSubview:_pixelFormatType];
        
        
        top = _renderType.bottom + 10;
        
    }
    
    {
        UILabel *label = [self createTagLabel:@"屏幕适配类型" top:top];
        [self.scrollView addSubview:label];
        top = label.bottom + 5;
        
        _aspectType = [[UISegmentedControl alloc] initWithItems:@[@"按比例适配",@"按比例填充",@"填充铺满"]];
        _aspectType.frame = CGRectMake(15, top, (Width - 60), 28);
        _aspectType.selectedSegmentIndex = 0;
        _aspectType.tag = 1;
        //        [_flvType addTarget:self action:@selector(segementChanged:) forControlEvents:UIControlEventValueChanged];
        [self.scrollView addSubview:_aspectType];
        
        top = _aspectType.bottom + 10;
        
    }
//    
//    {
//        UILabel *label = [self createTagLabel:@"聊天推送类型" top:top];
//        [self.scrollView addSubview:label];
//        top = label.bottom + 5;
//        
//        _chatType = [[UISegmentedControl alloc] initWithItems:@[@"实时推送",@"全部一次获取"]];
//        _chatType.frame = CGRectMake(15, top, (Width - 60), 28);
//        _chatType.selectedSegmentIndex = 0;
//        _chatType.tag = 1;
//        //        [_flvType addTarget:self action:@selector(segementChanged:) forControlEvents:UIControlEventValueChanged];
//        [self.scrollView addSubview:_chatType];
//        
//        top = _chatType.bottom + 10;
//        
//    }
    //NSUserDefault
    [self loadCache];
    
#if 0
    NSDictionary * passWordDict = @{@"79906129":@"333333",@"26529870":@"333333",@"71975566":@"888888",@"19501645":@"092853"};
    
    GSTextFieldTitleView * rnfieldview = [_fieldViewsDic objectForKey:MO_ROOMID];
//    rnfieldview.field.text = @"32827906,79906129,26529870,71975566,19501645,32827906,79906129";
    rnfieldview.field.text = @"32827906";

//        rnfieldview.field.text = @"98651557,39840100,82040835,87217444,94782256,04635404,77583062,07486933,07330757,79188369,54195892,81893278,66924570,47136434";
               
//    rnfieldview.field.text = @"34548668,48896990,36155423,04582953,76787146,15688534,44692326,42456164,43628124,67488410,15623243,48896990,34548668,48896990,36155423,04582953,76787146,15688534,44692326,42456164,43628124,67488410,15623243,48896990,36155423,04582953,76787146,15688534,44692326,42456164,43628124,67488410,15623243,48896990";
    

            /// 31532231,35166139 密码不对
            /// 08511911,6654?ZX 6415 多实例模式看不到画面，也听不到声音
            GSTextFieldTitleView * pwfieldview = [_fieldViewsDic objectForKey:MO_PWD];
            NSMutableArray * pwArray = [[NSMutableArray alloc] init];
            for (NSString * roomNum in [rnfieldview.field.text componentsSeparatedByString:@","]) {
                if([passWordDict.allKeys containsObject:roomNum]){
                    [pwArray addObject:[passWordDict objectForKey:roomNum]];
                }else{
                    [pwArray addObject:@""];
                }
            }
            pwfieldview.field.text = [pwArray componentsJoinedByString:@","];
            
            GSTextFieldTitleView * dominfieldview = [_fieldViewsDic objectForKey:MO_DOMAIN];
            dominfieldview.field.text = @"192.168.188.230";
//            dominfieldview.field.text = @"emoney.gensee.com";
            
            GSTextFieldTitleView * namefieldview = [_fieldViewsDic objectForKey:MO_NICKNAME];
            namefieldview.field.text = @"测试";
//        self.serviceType.selectedSegmentIndex = 1;
            self.serviceType.selectedSegmentIndex = 0;
    
//    UIBarButtonItem *item = [[UIBarButtonItem alloc] initWithTitle:@"多点播测试" style:UIBarButtonItemStylePlain target:self action:@selector(beTester)];
//    
//    self.navigationItem.rightBarButtonItems = @[item];
    

#endif
    
    self.scrollView.contentSize = CGSizeMake(Width, top);
    
    {
        
        //按钮事件 - 观看
        UIButton *watch   = [[UIButton alloc] initWithFrame:CGRectMake(50.f , Height - 60.f, (Width-100), 40.f)];
        [watch setTitle:@"在线观看" forState:UIControlStateNormal];
        watch.layer.cornerRadius         = 3.f;
        watch.layer.borderColor          = FASTSDK_COLOR16(0x009BD8).CGColor;
        watch.layer.borderWidth          = 0.5f;
        watch.layer.masksToBounds        = YES;
        watch.backgroundColor = FASTSDK_COLOR16(0x009BD8);
        [watch addTarget:self action:@selector(watch:) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:watch];
    }
    UIBarButtonItem * remove = [[UIBarButtonItem alloc] initWithTitle:@"删除缓存文件" style:UIBarButtonItemStylePlain target:self action:@selector(removeVodFiles)];

    self.navigationItem.rightBarButtonItems = @[remove];
    
    
    self.memoryLabel = [[UILabel alloc] init];
    self.memoryLabel.textColor =  FASTSDK_COLOR16(0x009BD8);
    self.memoryLabel.textAlignment = NSTextAlignmentCenter;
    self.memoryLabel.frame = CGRectMake(20, Height - 160.f, (Width-40), 100);
    self.memoryLabel.text = [NSString stringWithFormat:@"在线观看文件内存: %@",[GSVodTools getOnLineVodFilesSizeWithPath:[GSVodObject getVodOnlineFilesPath]]];
    [self.view addSubview:self.memoryLabel];

}

- (void)removeVodFiles{
    [GSVodTools removeOnLineVodFilesWithPath:[GSVodObject getVodOnlineFilesPath]];
    self.memoryLabel.text = [NSString stringWithFormat:@"在线观看文件内存: %@",[GSVodTools getOnLineVodFilesSizeWithPath:[GSVodObject getVodOnlineFilesPath]]];

}

- (void)beTester {
    GSVodTestViewController * vodTestVC = [[GSVodTestViewController alloc] init];
    [self.navigationController pushViewController:vodTestVC animated:YES];
}

- (void)watch:(UIButton*)sender {
    sender.userInteractionEnabled = NO;
    
    //存储相关参数到NSUserDefault
    [self saveCache];
    
    //param
    GSConnectInfo *params = [GSConnectInfo new];
    params.domain = [self _fieldText:MO_DOMAIN];
    params.roomNumber = @"";//[self _fieldText:MO_ROOMID];
    params.loginName = [self _fieldText:MO_LOGIN_NAME];
    params.watchPassword = @"";//[self _fieldText:MO_PWD];
    params.loginPassword = [self _fieldText:MO_LOGIN_PWD];
    params.nickName = [self _fieldText:MO_NICKNAME];
    params.serviceType = self.serviceType.selectedSegmentIndex == 0?0:1;
    params.oldVersion = NO;
    params.thirdToken = [self _fieldText:MO_THIRD_KEY];
    params.userData = @"123";
    if ([self _fieldText:MO_USERID].length > 0) {
        params.customUserID = [[self _fieldText:MO_USERID] longLongValue];
    }
    
    [GSVodManager sharedInstance].pixelFormat = self.pixelFormatType.selectedSegmentIndex;

    _state.isOnline = YES;

    GSVodListTableViewController *player = [[GSVodListTableViewController alloc] init];
    player.params = params;
    NSString * roomNumbers = [self _fieldText:MO_ROOMID];
    player.roomNumbers = [roomNumbers componentsSeparatedByString:@","];
    
    NSString * watchPassword = [self _fieldText:MO_PWD];
    player.passwordNumbers = [watchPassword componentsSeparatedByString:@","];
    
    player.renderMode = _renderType.selectedSegmentIndex == 0 ? GSVideoRenderOpenGL : GSVideoRenderAVSBDLayer;
    player.videoMode = _aspectType.selectedSegmentIndex == 0 ? UIViewContentModeScaleAspectFit : (_aspectType.selectedSegmentIndex == 1 ? UIViewContentModeScaleAspectFill : UIViewContentModeScaleToFill);
    player.isFlv = _flvType.selectedSegmentIndex == 1?YES:NO;
    player.hardwareAccelerate = _hardType.selectedSegmentIndex == 1?YES:NO;
    player.isHttps = _httpType.selectedSegmentIndex == 1?YES:NO;


    [self.navigationController pushViewController:player animated:YES];
    //设置间隔
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        sender.userInteractionEnabled = YES;
    });

}


- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [super touchesBegan:touches withEvent:event];
    [self.view resignFirstResponder];
}

//data
#pragma mark - data

- (void)saveCache {
    [[NSUserDefaults standardUserDefaults] setObject:[NSNumber numberWithInteger:self.serviceType.selectedSegmentIndex] forKey:MO_SERVICE];
    [self _saveField:MO_DOMAIN];
    [self _saveField:MO_ROOMID];
    [self _saveField:MO_NICKNAME];
    [self _saveField:MO_PWD];
    [self _saveField:MO_LOGIN_NAME];
    [self _saveField:MO_LOGIN_PWD];
    [self _saveField:MO_THIRD_KEY];
    [self _saveField:MO_USERID];
    
}

- (void)_saveField:(NSString *)fieldMark {
    NSString *text = [self _fieldText:fieldMark];
    if (text.length > 0) {
        [[NSUserDefaults standardUserDefaults] setObject:text forKey:fieldMark];
    }else{
        if ([[NSUserDefaults standardUserDefaults] objectForKey:fieldMark]) {
            [[NSUserDefaults standardUserDefaults] setObject:@"" forKey:fieldMark];
        }
    }
}

- (NSString *)_fieldText:(NSString *)fieldMark {
    GSTextFieldTitleView *fieldView = [_fieldViewsDic objectForKey:fieldMark];
    
    NSString *cleanString = [fieldView.field.text stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
    
    return cleanString;
}

- (void)loadCache {
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_DOMAIN]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"qa100.gensee.com" forKey:MO_DOMAIN];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_DOMAIN];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_DOMAIN];
    }
    
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_SERVICE]) {
        [[NSUserDefaults standardUserDefaults] setObject:@0 forKey:MO_SERVICE];
    }else{
        self.serviceType.selectedSegmentIndex = [[[NSUserDefaults standardUserDefaults] objectForKey:MO_SERVICE] intValue];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_ROOMID]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"" forKey:MO_ROOMID];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_ROOMID];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_ROOMID];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_NICKNAME]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"genseeTest" forKey:MO_NICKNAME];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_NICKNAME];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_NICKNAME];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_PWD]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"" forKey:MO_PWD];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_PWD];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_PWD];
    }
    
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_NAME]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_LOGIN_NAME];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_NAME];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_PWD]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_LOGIN_PWD];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_PWD];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_THIRD_KEY]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_THIRD_KEY];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_THIRD_KEY];
    }
    
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_USERID]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_USERID];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_USERID];
    }
    
}

- (void)dealloc {
    [_fieldViewsDic removeAllObjects];
    NSLog(@"GSFastConfigController dealloc");
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - rotation

- (BOOL)shouldAutorotate {
    return NO;
}
- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}
- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
    return UIInterfaceOrientationPortrait;
}

@end
